package sample;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;

import javax.swing.*;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class Controller {
    @FXML
    private Button cbGetIP;
    @FXML
    private Button cbGetHName;
    @FXML
    private TextField tfHostName;
    @FXML
    private TextField tfIP;

    public void findNameOrIP(ActionEvent ae) {
        try {
            if (ae.getSource() == cbGetIP) {
                InetAddress ia = InetAddress.getByName(tfHostName.getText());
                tfIP.setText(ia.getHostAddress());
            } else {
                byte[] ipAddr = new byte[4];
                StringTokenizer st = new StringTokenizer(tfIP.getText(), ".", false);
                for (int i = 0; i < 4; i++)
                    ipAddr[i] = (byte) Integer.parseInt(st.nextToken());
                InetAddress ia = InetAddress.getByAddress(ipAddr);
                tfHostName.setText(ia.getHostName());
            }
        } catch(Exception e) {
            Alert alert = new Alert(Alert.AlertType.INFORMATION, e.getMessage());
            alert.setHeaderText("Die Auflösung ist gescheitert.");
            alert.showAndWait();
        }
    }
}
