class Lager {
	private int bilanz;
 	private int anz;

	Lager(int start) {
		bilanz = start;
		System.out.println("Der Laden ist offen (Bestand = "+bilanz+")\n");
	}

	private String formZeit() {
		return java.text.DateFormat.getTimeInstance().format(new java.util.Date());
	}

	synchronized void ergaenze(int add) {
		bilanz += add;
		anz++;
		System.out.println("Nr. " + anz+":\t" + Thread.currentThread().getName()+
			" ergänzt\t\t\t" + add + "\tum " + formZeit() + " Uhr. Stand: " + bilanz);
		notify();
	}

	synchronized void liefere(int sub, int custID) {
		while (bilanz < sub)
			try {
				System.out.println(Thread.currentThread().getName() +
					" muss warten: Keine " + sub + " Einheiten vorhanden.");
				wait();
			}  catch (InterruptedException ie) { /* Ignorieren ist OK, weil kein Interrupt signalisiert wird. */}

		bilanz -= sub;
		anz++;
		System.out.println("Nr. "+anz+":\t" + Thread.currentThread().getName() +
			" (Kunde " + custID + ") entnimmt\t" + sub + "\tum " + formZeit() + " Uhr. Stand: " + bilanz);
	}
}