import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;

class RandomNumberCruncher implements Callable<Double> {
    public Double call() throws TimeoutException {
        final int maxNum = 200_000_000;
        final int maxTime = 5_000;
        double d = 0.0;
        long start = System.currentTimeMillis();
        for (int i = 0; i < maxNum; i++) {
            d += Math.random();
            if (System.currentTimeMillis() - start > maxTime)
                throw new TimeoutException();
        }
        return d / maxNum;
    }
}