import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.*;

class CallableDemo {
	public static void main(String[] args) {
		DateFormat df = DateFormat.getDateTimeInstance();
		try (ExecutorService es = Executors.newSingleThreadExecutor()) {
			Future<Double> fd = es.submit(new RandomNumberCruncher());
			while (!fd.isDone()) {
				System.out.println("Warten auf call() - Ende (" + df.format(new Date()) + ")");
				Thread.sleep(1_000);
			}
			System.out.println("\nMittelwert der Zufallszahlen: " + fd.get());
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}