import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.geometry.*;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

import java.util.concurrent.CompletableFuture;

public class TaskDemo extends Application {
	private int numClicks = 0;
	private final long anz = 100_000_000;
	private RandomNumberCruncher task;
	private final Label lblMessage = new Label();
	private final ProgressBar progBar = new ProgressBar();

	public void start(Stage stage) {
		int dist = 10;
		var root = new GridPane();
		root.setHgap(dist); root.setVgap(dist);
		root.setPadding(new Insets(dist, dist, dist, dist));

		String lblPrefix = "Zählerstand: ";
		var lblStand = new Label(lblPrefix + "0");

		var btnAdd = new Button("Zählerstand erhöhen");
		btnAdd.setOnAction(event -> {
			numClicks++;
			lblStand.setText(lblPrefix + numClicks);
		});
		btnAdd.setDefaultButton(true);

		progBar.setProgress(0.0);

		var btnTask = new Button("Mittel von " + anz + " Zufallszahlen");
		btnTask.setOnAction(event -> {
			task = new RandomNumberCruncher();
//			task.setOnSucceeded(e -> {lblMessage.setText("Ergebnis: " + task.getValue());});
			CompletableFuture.runAsync(task);
			lblMessage.textProperty().bind(task.messageProperty());
			progBar.progressProperty().bind(task.progressProperty());
		});

		var btnCancel = new Button("Hintergrund-Task abbrechen");
		btnCancel.setOnAction(event -> {if (task != null) task.cancel();});

		root.add(btnAdd, 0, 0);
		root.add(lblStand, 0, 1);
		root.add(lblMessage, 0, 2);
		root.add(progBar, 0, 3);
		root.add(btnTask, 0, 4);
		root.add(btnCancel, 0, 5);

		stage.setScene(new Scene(root, 240, 200));
		stage.setTitle("JavaFX-Task");
		stage.show();
	}

	private class RandomNumberCruncher extends Task<Double> {
		@Override
		protected Double call() {
			double d = 0.0;
			for (long i = 0; i < anz; i++) {
				if (this.isCancelled()) {
					this.updateMessage("Die Aufgabe wurde abgebrochen.");
					break;
				}
				d += Math.random();
				if ((i+1)%1_000_000 == 0)
					this.updateMessage("Iteration: " + (i+1));
				this.updateProgress(i, anz);
			}
			return d / anz;
		}
		@Override
		protected void succeeded() {
			super.succeeded();
			this.updateMessage("Ergebnis: " + this.getValue());
		}
	}

	public static void main(String[] args) {
		Application.launch(args);
	}
}
