import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.*;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

import java.util.concurrent.CompletableFuture;

public class RunLater extends Application {
	private int numClicks = 0;
	private final long anz = 500_000_000;
	private double randomSum;
	private final Label lblMessage = new Label();

	public void start(Stage stage) {
		int dist = 10;
		var root = new GridPane();
		root.setHgap(dist); root.setVgap(dist);
		root.setPadding(new Insets(dist, dist, dist, dist));

		String lblPrefix = "Zählerstand: ";
		var lblStand = new Label(lblPrefix + "0");

		var btnAdd = new Button("Zählerstand erhöhen");
		btnAdd.setOnAction(event -> {
			numClicks++;
			lblStand.setText(lblPrefix + numClicks);
		});
		btnAdd.setDefaultButton(true);

		var btnTask = new Button("Mittel von " + anz + " Zufallszahlen");
		btnTask.setOnAction(event -> {
			lblMessage.setText("Ergebnis:");
			CompletableFuture.runAsync(() -> {
						randomSum = 0.0;
						for (long i = 0; i < anz; i++)
							randomSum += Math.random();
						Platform.runLater(() ->
								lblMessage.setText("Ergebnis: " + String.format("%7.4f", randomSum / anz)));
					});
		});

		root.add(btnAdd, 0, 0);
		root.add(lblStand, 0, 1);
		root.add(lblMessage, 0, 2);
		root.add(btnTask, 0, 3);

		stage.setScene(new Scene(root));
		stage.setTitle("Run Later");
		stage.show();
	}

	public static void main(String[] args) {
		Application.launch(args);
	}
}
