import java.util.concurrent.*;

class WhenCompleteAsync {
	public static void main(String[] args) {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1): " + Thread.currentThread().getName());
			if (true)
				throw new IllegalStateException("cf1 failed");
			return 1;
		});

		CompletableFuture<Integer> cf2 = cf1.thenApplyAsync(i -> {
			System.out.println("Thread(cf2): " + Thread.currentThread().getName());
			return ++i;
		});

		CompletableFuture<Integer> cf3 = cf2.whenCompleteAsync((i, ex) -> {
			System.out.println("\napply() von cf3");
			if (ex != null) {
				System.out.println("    class:   " + ex.getClass());
				System.out.println("    Cause:   " + ex.getCause().getClass().getName());
				System.out.println("    Message: " + ex.getCause().getMessage());
			}
			System.out.println("Thread(cf3): " + Thread.currentThread().getName());
			System.out.println("Ergebnis:    " + i);
		});

		try {
			ForkJoinPool.commonPool().awaitQuiescence(3000, TimeUnit.MILLISECONDS);
			System.out.println("\ncf3.get() in main()");
			System.out.println(cf3.join());
		} catch (Exception ex) {
			System.out.println(ex.getMessage());
		}
	}
}

