import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class ThenCombineAsync {
	public static void main(String[] args)  {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {	/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf1): " + Thread.currentThread().getName());
			return 2;
		});

		CompletableFuture<Integer> cf2 = CompletableFuture.supplyAsync(() -> {
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {	/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf2): " + Thread.currentThread().getName());
			return 3;
		});

		CompletableFuture<String> cf3 = cf1.thenCombineAsync(cf2, (i, j) -> {
			System.out.println("Thread(cf3): " + Thread.currentThread().getName());
			return "Ergebnis:    " + i + " to the power of " + j +" = " + Math.pow(i, j);
		});
		System.out.println(cf3.join());

//		ExecutorService es = Executors.newCachedThreadPool();
//		CompletableFuture<String> cf3 = cf1.thenCombineAsync(cf2, (i, j) -> {
//			System.out.println("Thread(cf3): " + Thread.currentThread().getName());
//			return "Ergebnis:    " + i + " to the power of " + j +" = " + Math.pow(i, j);
//		}, es);
//		System.out.println(cf3.join());
//		es.shutdown();
	}
}

