import java.util.concurrent.*;

class ThenApplyAsync {
	public static void main(String[] args)  throws InterruptedException {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1): " + Thread.currentThread().getName());
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			return 1;
		});

		Thread.sleep(3000);

		CompletableFuture<Void> cf2 = CompletableFuture.runAsync(() -> {
			try {Thread.sleep(3000);
			} catch (InterruptedException ix) {/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf2): " + Thread.currentThread().getName());
		});

		CompletableFuture<Integer> cf3 = cf1.thenApplyAsync(i -> {
			System.out.println("Thread(cf3): " + Thread.currentThread().getName());
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			return ++i;
		});

//		ExecutorService es = Executors.newCachedThreadPool();
//		CompletableFuture<Integer> cf3 = cf1.thenApplyAsync(i -> {
//			System.out.println("Thread(cf3): " + Thread.currentThread().getName());
//			try {Thread.sleep(1000);
//			} catch (InterruptedException ix) {/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
//			return ++i;
//		}, es);
//		es.shutdown();

		System.out.println("Ergebnis:    " + cf3.join());
		ForkJoinPool.commonPool().awaitQuiescence(3000, TimeUnit.MILLISECONDS);
	}
}

