import java.util.concurrent.CompletableFuture;

class ThenApply {
	public static void main(String[] args) throws InterruptedException {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1): " + Thread.currentThread().getName());
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			return 1;
		});

		Thread.sleep(3000);

		CompletableFuture<Integer> cf2 = cf1.thenApply(i -> {
			System.out.println("Thread(cf2): " + Thread.currentThread().getName());
			return ++i;
		});

		System.out.println("Ergebnis:    " + cf2.join());
	}
}
