import java.util.concurrent.*;

class ThenAcceptAsync {
	public static void main(String[] args)  {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1): " + Thread.currentThread().getName());
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			return 1;
		});

		CompletableFuture<Void> cf2 = cf1.thenAcceptAsync(i -> {
			System.out.println("Thread(cf2): " + Thread.currentThread().getName());
			System.out.println("Ergebnis:    " + ++i);
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
		});

		ForkJoinPool.commonPool().awaitQuiescence(5000, TimeUnit.MILLISECONDS);
//		cf2.join();

//		ExecutorService es = Executors.newCachedThreadPool();
//		CompletableFuture<Void> cf2 = cf1.thenAcceptAsync(i -> {
//			System.out.println("Thread(cf2): " + Thread.currentThread().getName());
//			System.out.println("Ergebnis:    " + ++i);
//			try {Thread.sleep(1000);
//			} catch (InterruptedException ix) {
//	     		/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
//		}, es);
//		cf2.join();
//		es.shutdown();
	}
}

