import java.util.concurrent.CompletableFuture;

class Exceptionally {
	public static void main(String[] args) {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1):   " + Thread.currentThread().getName());
			if (true)
				throw new IllegalStateException("cf1 failed");
			return 1;
		});

		cf1 = cf1.exceptionally(ex ->  {
			System.out.println("\nAusnahme:      " + ex);
			System.out.println("Thread(exept): " + Thread.currentThread().getName() + "\n");
			return 0;
		});

		CompletableFuture<Integer> cf2 = cf1.thenApplyAsync(i -> {
			System.out.println("Thread(cf2):   " + Thread.currentThread().getName());
			return ++i;
		});

		CompletableFuture<Void> cf3 = cf2.thenAcceptAsync(i -> {
			System.out.println("Thread(cf3):   " + Thread.currentThread().getName());
			System.out.println("\nErgebnis:      " + i);
		});

		cf3.join();
	}
}

