import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class ApplyToEitherAsync {
	public static void main(String[] args)  {
		CompletableFuture<String> cf1 = CompletableFuture.supplyAsync(() -> {
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {	/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf1): " + Thread.currentThread().getName());
			return "Tulpen";
		});

		CompletableFuture<String> cf2 = CompletableFuture.supplyAsync(() -> {
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {	/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf2): " + Thread.currentThread().getName());
			return "Nelken";
		});

		CompletableFuture<String> cf3 = cf1.applyToEitherAsync(cf2, s -> {
			System.out.println("Thread(cf3): " + Thread.currentThread().getName());
			return "Ergebnis:    Heute im Angebot: " + s;
		});
		System.out.println(cf3.join());

//		ExecutorService es = Executors.newCachedThreadPool();
//		CompletableFuture<String> cf3 = cf1.applyToEitherAsync(cf2, s -> {
//			System.out.println("Thread(cf3): " + Thread.currentThread().getName());
//			return "Ergebnis:    Heute im Angebot: " + s;
//		}, es);
//		System.out.println(cf3.join());
//		es.shutdown();
	}
}

