import java.util.concurrent.*;

class AnyOf {
	public static void main(String[] args)  {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			try {Thread.sleep(200);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf1):  " + Thread.currentThread().getName());
			return 1;
		});

		CompletableFuture<Integer> cf2 = CompletableFuture.supplyAsync(() -> {
			try {Thread.sleep(200);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf2):  " + Thread.currentThread().getName());
			return 2;
		});

		CompletableFuture<Integer> cf3 = CompletableFuture.supplyAsync(() -> {
			try {Thread.sleep(300);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			System.out.println("Thread(cf3):  " + Thread.currentThread().getName());
			if (true)
				throw new IllegalStateException("cf3 failed");
			return 3;
		});

		CompletableFuture.anyOf(cf1, cf2, cf3).whenCompleteAsync((result, ex) -> {
			if (ex != null) {
				System.out.println("\nTask series failed with exception:");
				System.out.println(" Exception: " + ex.getClass().getName());
				System.out.println(" Cause:     " + ex.getCause().getClass().getName());
				System.out.println(" Message:   " + ex.getCause().getMessage());
			}
			System.out.println(result);
		});
		ForkJoinPool.commonPool().awaitQuiescence(3000, TimeUnit.MILLISECONDS);
	}
}