import java.util.List;
import java.util.concurrent.*;

class AllOf {
	public static void main(String[] args) {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1):  " + Thread.currentThread().getName());
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			return 1;
		});

		CompletableFuture<Integer> cf2 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf2):  " + Thread.currentThread().getName());
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			return 2;
		});

		CompletableFuture<Integer> cf3 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf3):  " + Thread.currentThread().getName());
			try {Thread.sleep(1000);
			} catch (InterruptedException ix) {
				/* Ignorieren ist OK, weil kein Interrupt signalisiert wird.*/ }
			if (false)
				throw new IllegalStateException("cf3 failed");
			return 3;
		});

		CompletableFuture.allOf(cf1, cf2, cf3).whenCompleteAsync((i, ex) -> {
			if (ex != null) {
				System.out.println("\nTask series failed with exception:");
				System.out.println(" Exception: " + ex.getClass().getName());
				System.out.println(" Cause:     " + ex.getCause().getClass().getName());
				System.out.println(" Message:   " + ex.getCause().getMessage());
			}
			for(var cf: List.of(cf1, cf2, cf3))
				System.out.println(cf.join());
		});

		ForkJoinPool.commonPool().awaitQuiescence(3000, TimeUnit.MILLISECONDS);
	}
}