import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;

class TryGetCatch {
	public static void main(String[] args) throws InterruptedException {
		CompletableFuture<Integer> cf1 = CompletableFuture.supplyAsync(() -> {
			System.out.println("Thread(cf1):  " + Thread.currentThread().getName());
			if (true)
				throw new IllegalStateException("cf1 failed");
			return 1;
		});

		CompletableFuture<Integer> cf2 = cf1.thenApplyAsync(i -> {
			System.out.println("Thread(cf2):  " + Thread.currentThread().getName());
			return ++i;
		});

		CompletableFuture<Void> cf3 = cf2.thenAcceptAsync(i -> {
			System.out.println("Thread(cf3):  " + Thread.currentThread().getName());
			System.out.println("Ergebnis:     " + i);
		});

		ForkJoinPool.commonPool().awaitQuiescence(3000, TimeUnit.MILLISECONDS);

		System.out.println("\nVerarbeitung abgebrochen? " +
						   cf3.isCompletedExceptionally());
		try {
			cf3.join();
		} catch (Exception ex) {
			System.out.println("\n" + ex);
		}
		System.out.println("\nAufgabenstatus:");
		System.out.println("cf1:    " + cf1);
		System.out.println("cf2:    " + cf2);
		System.out.println("cf3:    " + cf3);
	}
}
