package de.bebagoe.jfxcontrols;

import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.layout.*;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class Umschalter extends Application {
    private CheckBox cbBold = new CheckBox("Fett"),
                     cbItalic = new CheckBox("Kursiv");
	private RadioButton rbSans = new RadioButton("Sans Serif"),
			rbSerif = new RadioButton("Serif"),
			rbMono = new RadioButton("Monospaced");
    private Label lblBeispiel = new Label("Beispieltext");

    private double fontSize = 24.0;
    private String ffSans = "Arial", ffSerif = "Times New Roman", ffMono = "Courier New";
    private FontWeight fontWeight = FontWeight.NORMAL;
    private FontPosture fontPosture = FontPosture.REGULAR;

    @Override
    public void start(Stage stage) {
        double dist = 10.0;
        var root = new GridPane();
        root.setVgap(dist);root.setHgap(2*dist);
        root.setPadding(new Insets(dist, dist, dist, dist));

        var vboxCheck = new VBox(dist);
        var vboxRadio = new VBox(dist);
        root.add(vboxCheck, 0, 0);
        root.add(vboxRadio, 1, 0);
        root.add(lblBeispiel, 2, 0);

        lblBeispiel.setFont(Font.font(ffSans, fontWeight, fontPosture, fontSize));

        vboxCheck.getChildren().addAll(cbBold, cbItalic);

        cbBold.selectedProperty().addListener(this::cbChanged);
        cbItalic.selectedProperty().addListener(this::cbChanged);

        vboxRadio.getChildren().addAll(rbSans, rbSerif, rbMono);

        var rbGroup = new ToggleGroup();
        rbGroup.getToggles().addAll(rbSans, rbSerif, rbMono);
        rbSans.setSelected(true);

        rbGroup.selectedToggleProperty().addListener(this::rbChanged);

        stage.setScene(new Scene(root, 400, 100));
        stage.setTitle("CheckBox und RadioButton");
        stage.show();
    }

	private void cbChanged(ObservableValue<? extends Boolean> obs, Boolean old, Boolean nev) {
		if (obs.equals(cbBold.selectedProperty()))
			if (nev == true)
				fontWeight = FontWeight.BOLD;
			else
				fontWeight = FontWeight.NORMAL;
		else
			if (nev == true)
				fontPosture = FontPosture.ITALIC;
			else
				fontPosture = FontPosture.REGULAR;
		lblBeispiel.setFont(Font.font(lblBeispiel.getFont().getFamily(), fontWeight, fontPosture, fontSize));
	}

	private void rbChanged(ObservableValue<? extends Toggle> obs, Toggle old, Toggle nev) {
		String family = null;
		if (nev == rbMono) {
			family = ffMono;
		} else if (nev == rbSerif) {
			family = ffSerif;
		} else if (nev == rbSans) {
			family = ffSans;
		}
		lblBeispiel.setFont(Font.font(family, fontWeight, fontPosture, fontSize));
	}

    public static void main(String[] args) {
        launch(args);
    }
}