package de.bebagoe.jfxcontrols;

import javafx.application.Application;
import javafx.geometry.*;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class TextFieldDemo extends Application {
    @Override
    public void start(Stage stage) {
        double dist = 10.0;
        var root = new VBox(dist);
        root.setPadding(new Insets(dist, dist, dist, dist));

        var label = new Label("Bitte Vor- und Familiennamen eintragen " +
				"und mit Enter quittieren:");
        var name = new TextField();

//		name.setAlignment(Pos.BASELINE_RIGHT); // Text rechtsbündig
//		name.setEditable(false); // Text nicht editierbar)

        root.getChildren().addAll(label, name);

        name.setOnAction(e -> {
            var alert = new Alert(AlertType.INFORMATION, "Sie heißen " + name.getText());
            alert.showAndWait();
        });

        stage.setScene(new Scene(root));
        stage.setTitle("TextField");
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}