package de.bebagoe.jfxcontrols;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class PasswordFieldDemo extends Application {
    @Override
    public void start(Stage stage) {
        double dist = 10.0;
        var root = new HBox(dist);
        root.setPadding(new Insets(dist, dist, dist, dist));

        var label = new Label("Ihr Passwort: ");
        var pw = new PasswordField();

        pw.setOnAction(e -> {
            Alert alert = new Alert(AlertType.INFORMATION, "Ihr Passwort: " + pw.getText());
            alert.showAndWait();
        });

        root.getChildren().addAll(label, pw);
        root.setAlignment(Pos.CENTER);

        stage.setScene(new Scene(root, 300, 50));
        stage.setTitle("PasswordField");
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}