// Mit Konstruktoren

public class Bruch {
	private int zaehler;          // wird automatisch mit 0 initialisiert
	private int nenner = 1;       // wird manuell mit 1 initialisiert
	private String etikett = "";  // die Referenztyp-Init. auf null wird ersetzt

    public Bruch(int z, int n, String eti) {
        setzeZaehler(z);
        setzeNenner(n);
        setzeEtikett(eti);
    }

    public Bruch() {
        //	this(0, 1, "unbenannt");
    }

	public void setzeZaehler(int z) {zaehler = z;}

	public boolean setzeNenner(int n) {
		if (n != 0) {
			nenner = n;
			return true;
		} else
			return false;
	}

	public void setzeEtikett(String eti) {
		if (eti.length() <= 40)
			etikett = eti;
		else
			etikett = eti.substring(0, 40);
	}

	public int gibZaehler() {return zaehler;}

	public int gibNenner() {return nenner;}

	public String gibEtikett() {return etikett;}

	public void kuerze() {
		// größten gemeinsamen Teiler mit dem euklidischen Algorithmus bestimmen
		// (performante Variante mit Modulo-Operator)
		if (zaehler != 0) {
			int rest;
			int ggt = Math.abs(zaehler);
			int divisor = Math.abs(nenner);
			do {
				rest = ggt % divisor;
				ggt = divisor;
				divisor = rest;
			} while (rest > 0);
			zaehler /= ggt;
			nenner  /= ggt;
		} else
			nenner = 1;
	}

	public void addiere(Bruch b) {
		zaehler = zaehler*b.nenner + b.zaehler*nenner;
		nenner = nenner*b.nenner;
		kuerze();
	}

    public boolean addiere(int z, int n, boolean autokurz) {
        if (n != 0) {
            zaehler = zaehler*n + z*nenner;
            nenner = nenner*n;
            if (autokurz)
                kuerze();
            return true;
        } else
            return false;
    }

    public void addiere(Bruch... bar) {
        for (Bruch b : bar)
            addiere(b);
    }

    public void dupliziere(Bruch bc) {
        bc.zaehler = zaehler;
        bc.nenner = nenner;
        bc.etikett = etikett;
    }

	public void zeige() {
		String luecke = "";
		final int el = etikett.length();
		for (int i = 1; i <= el; i++)
			luecke = luecke + " ";
		IO.println(" " + luecke  + "   " + zaehler + "\n" +
                   " " + etikett + " -----\n" +
                   " " + luecke  + "   " + nenner + "\n");
	}
}