package de.bebagoe.attendance;

import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.*;
import javafx.stage.Stage;
import java.util.Comparator;

public class GridAnchorBorderPane extends Application {
	private Label lblName = new Label("Name:");
	private Label lblPresent = new Label("Anwesend:");
	private TextField tfName = new TextField();
	private ListView<String> lvPersons;
	private Button btnAdd = new Button("Angekommen");
	private Button btnRemove = new Button("Gegangen");

	@Override
	public void start(Stage primaryStage) {
		String[] anwesend = new String[] {"Willi", "Otto", "Theo", "Irma", "Doro", "Heiner", "Michael", "Ludger", "Ben"};

		ObservableList<String> people = FXCollections.observableArrayList(anwesend);
		SortedList<String> perSorted = new SortedList<>(people, Comparator.naturalOrder());
		lvPersons = new ListView<>(perSorted);

		btnAdd.setOnAction(event -> {
			String s = tfName.getText();
			if (s.length() > 0  &&  !people.contains(s))
				people.add(s);
		});

		btnRemove.setOnAction(event ->
				people.remove(lvPersons.getSelectionModel().getSelectedItem()));

		Parent root = makeGridPane();
//	        Parent root = makeAnchorPane();
//	        Pane root = makeBorderPane();

		primaryStage.setTitle("Anwesenheitskontrolle");
		primaryStage.setScene(new Scene(root, 450, 200));
		primaryStage.setMinWidth(400);
		primaryStage.setMinHeight(150);
		primaryStage.show();
	}

    private Pane makeGridPane() {
		double dist = 10.0;

		var root = new GridPane();
		root.setPadding(new Insets(dist, dist, dist, dist));
		root.setHgap(dist);
		root.setVgap(dist);

//		// columnIndex und rowIndex
//		root.getChildren().add(lblName);
//		GridPane.setColumnIndex(lblName, 0);
//		GridPane.setRowIndex(lblName, 0);

		root.add(lblName, 0, 0); root.add(tfName, 1, 0); root.add(btnAdd, 2, 0);
		root.add(lblPresent, 0, 1); root.add(lvPersons, 1, 1); root.add(btnRemove, 2, 1);

		 //Column-Span
//		root.add(lblName, 0, 0);
//		root.add(tfName, 1, 0);
//		root.add(btnAdd, 2, 0);
//		root.add(lblPresent, 0, 1);
//		root.add(lvPersons, 1, 1);
//		root.add(btnRemove, 3, 0);
//		GridPane.setColumnSpan(lvPersons, 3);
//		root.add(lvPersons, 1, 1, 3, 1);

		GridPane.setHalignment(btnAdd, HPos.RIGHT);
		GridPane.setHalignment(btnRemove, HPos.RIGHT);

		GridPane.setHgrow(tfName, Priority.ALWAYS);
//		GridPane.setVgrow(lvPersons, Priority.ALWAYS);

        // Column-Constraints
		ColumnConstraints col1 = new ColumnConstraints();
		col1.setPercentWidth(25);
		ColumnConstraints col2 = new ColumnConstraints();
		col2.setPercentWidth(50);
		ColumnConstraints col3 = new ColumnConstraints();
		col3.setPercentWidth(25);
		root.getColumnConstraints().addAll(col1, col2, col3);

//        GridPane.setMargin(lvPersons, new Insets(dist, dist, dist, dist));
//        root.setGridLinesVisible(true);
        return root;
    }

    private Pane makeAnchorPane() {
		var root = new AnchorPane();
		root.getChildren().addAll(lblName, lblPresent, tfName, lvPersons, btnAdd, btnRemove);

		double bd = 10.0;
		double ldc2 = 100.0;
		double rdc2 = 120.0;
		double tdr2 = 50.0;

		AnchorPane.setTopAnchor(lblName, bd); AnchorPane.setLeftAnchor(lblName, bd);
		AnchorPane.setTopAnchor(lblPresent, tdr2); AnchorPane.setLeftAnchor(lblPresent, bd);
		AnchorPane.setTopAnchor(btnAdd, bd); AnchorPane.setRightAnchor(btnAdd, bd);
		AnchorPane.setTopAnchor(btnRemove, tdr2); AnchorPane.setRightAnchor(btnRemove, bd);
		AnchorPane.setTopAnchor(tfName, bd); AnchorPane.setLeftAnchor(tfName, ldc2); AnchorPane.setRightAnchor(tfName, rdc2);
		AnchorPane.setTopAnchor(lvPersons, tdr2); AnchorPane.setBottomAnchor(lvPersons, bd);
		AnchorPane.setLeftAnchor(lvPersons, ldc2); AnchorPane.setRightAnchor(lvPersons, rdc2);

        return root;
    }

    private Pane makeBorderPane() {
		double dist = 10.0;
		double lblw = 70.0;
		double btnw = 100.0;
		var insets = new Insets(dist, dist, dist, dist);

		var top = new HBox();
		top.setAlignment(Pos.BASELINE_LEFT);
		HBox.setMargin(lblName, insets);
		lblName.setPrefWidth(lblw);
		HBox.setMargin(btnAdd, insets);
		btnAdd.setPrefWidth(btnw);
		HBox.setMargin(tfName, insets);
		HBox.setHgrow(tfName, Priority.ALWAYS);
		top.getChildren().addAll(lblName, tfName, btnAdd);

		var root = new BorderPane();
		BorderPane.setMargin(lvPersons, insets);
		BorderPane.setMargin(lblPresent, insets);
		BorderPane.setMargin(btnRemove, insets);

		lblPresent.setPrefWidth(lblw);
		btnRemove.setPrefWidth(btnw);
		BorderPane.setAlignment(lblPresent, Pos.CENTER_LEFT);
		BorderPane.setAlignment(btnRemove, Pos.CENTER_RIGHT);

		root.setTop(top);
		root.setLeft(lblPresent);
		root.setRight(btnRemove);
		root.setCenter(lvPersons);

        return root;
    }

    public static void main(String[] args) {
        launch(args);
    }
}
