package de.bebagoe.jfxlayoutman;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.*;
import javafx.stage.Stage;

public class FlowPaneDemo extends Application {
	@Override
	public void start(Stage stage) {
		double dist = 10.0;
		int nob = 10;
		double csize = 40.0;

		var root = new FlowPane();
		root.setPadding(new Insets(dist, dist, dist, dist));
		root.setHgap(dist); root.setVgap(dist);
	//        root.setAlignment(Pos.TOP_RIGHT);

		Button[] buttons = new Button[nob];
		for (int i = 0; i < nob; i++) {
			buttons[i] = new Button(String.valueOf(i + 1));
			buttons[i].setPrefWidth(csize); buttons[i].setPrefHeight(csize);
			buttons[i].setAlignment(Pos.CENTER);
		}
		root.getChildren().addAll(buttons);

		stage.setScene(new Scene(root, 250, 250));
		stage.setTitle("FlowPane");
		stage.show();
	}

    public static void main(String[] args) {
        launch(args);
    }
}