package de.bebagoe.boderpane;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.*;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class BorderPaneDemo extends Application {
	@Override
	public void start(Stage primaryStage) {
		double dist = 10.0;
		var insets = new Insets(dist, dist, dist, dist);

		var border = new Border(new BorderStroke(Color.BLACK, BorderStrokeStyle.SOLID, null, null));
		var root = new BorderPane();

		var oben = new Label("Oben");
		HBox.setMargin(oben, insets);
		var topBox = new HBox();
		topBox.setAlignment(Pos.CENTER);
		topBox.getChildren().add(oben);
		topBox.setBorder(border);

		var unten = new Label("Unten");
		HBox.setMargin(unten, insets);
		var botBox = new HBox();
		botBox.setAlignment(Pos.CENTER);
		botBox.getChildren().add(unten);
		botBox.setBorder(border);

		var links = new Label("Links");
		HBox.setMargin(links, insets);
		var leftBox = new HBox();
		leftBox.setAlignment(Pos.CENTER);
		leftBox.getChildren().add(links);
		leftBox.setBorder(border);

		var rechts = new Label("Rechts");
		HBox.setMargin(rechts, insets);
		var rightBox = new HBox();
		rightBox.setAlignment(Pos.CENTER);
		rightBox.getChildren().add(rechts);
		rightBox.setBorder(border);

		var zentrum = new Label("Zentrum");
		var cenBox = new HBox();
		cenBox.setAlignment(Pos.CENTER);
		cenBox.getChildren().add(zentrum);
		cenBox.setBorder(border);

		root.setTop(topBox);
		root.setBottom(botBox);
		root.setLeft(leftBox);
		root.setRight(rightBox);
		root.setCenter(cenBox);

		primaryStage.setTitle("BorderPane");
		primaryStage.setScene(new Scene(root, 400, 200));
		primaryStage.show();
	}
}
