package de.bebagoe.events;

import javafx.application.Application;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

public class Ereignisse extends Application {
    private int numClicks = 0;

	private static void presentEvent(Event event) {
		var alert = new Alert(Alert.AlertType.INFORMATION, event.getEventType().toString());
		alert.setHeaderText("Quelle: " + event.getSource().getClass().toString());
		alert.showAndWait();
//		event.consume();
	};

    @Override
    public void start(Stage stage) {
        VBox root = new VBox(10);

        String lblPrefix = "Zählerstand: ";
        Label lblText = new Label(lblPrefix + "0");

//        stage.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> presentEvent(event));
//        root.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> presentEvent(event));
//        lblText.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> presentEvent(event));

		lblText.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> presentEvent(event));
		root.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> presentEvent(event));
		stage.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> presentEvent(event));

        Button btnAdd = new Button("Zählerstand erhöhen");
        btnAdd.setOnAction(event -> lblText.setText(lblPrefix + ++numClicks));
//		btnAdd.setOnAction(null);

        root.getChildren().addAll(btnAdd, lblText);
        root.setAlignment(Pos.CENTER);

        Scene scene = new Scene(root, 340, 150);
        stage.setScene(scene);
        stage.setTitle("Multi Purpose Counter");
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}
