package de.bebagoe.attendance;

import java.util.Comparator;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;

public class Model {
	private ObservableList<String> persons;
	private SortedList<String> perSorted;

	public Model() {
		String[] anwesend = new String[] {"Willi", "Otto", "Theo", "Irma", "Doro",
				"Heiner", "Michael", "Ludger", "Ben"};
		persons = FXCollections.observableArrayList(anwesend);
		perSorted = new SortedList<>(persons, Comparator.naturalOrder());
	}

	public ObservableList<String> getSortedList() {
		return FXCollections.unmodifiableObservableList(perSorted);
	}

	public void add(String s) {
		if (!persons.contains(s))
			persons.add(s);
	}

	public void remove(String s) {
		persons.remove(s);
	}
}
