package de.bebagoe.attendance;

import javafx.application.Application;
import javafx.collections.*;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.layout.*;
import javafx.stage.Stage;
import java.util.Comparator;

public class Attendance extends Application {
	@Override
	public void start(Stage stage) {
		GridPane root = new GridPane();
		double dist = 10.0;
		root.setPadding(new Insets(dist, dist, dist, dist));
		root.setHgap(dist); root.setVgap(dist);

		Label lblName = new Label("Name:");
		Label lblPresent = new Label("Anwesend:");
		TextField tfName = new TextField();
		Button btnAdd = new Button("Angekommen");
		Button btnRemove = new Button("Gegangen");

		String[] anwesend = new String[] {"Willi", "Otto", "Theo", "Irma", "Doro",
				"Heiner", "Michael", "Ludger", "Ben"};
		ObservableList<String> persons = FXCollections.observableArrayList(anwesend);
		SortedList<String> perSorted = new SortedList<>(persons,
				Comparator.naturalOrder());
		ListView<String> lvPersons = new ListView<>(perSorted);

		root.add(lblName, 0, 0);
		root.add(tfName, 1, 0);
		root.add(btnAdd, 2, 0);
		root.add(lblPresent, 0, 1);
		root.add(lvPersons, 1, 1);
		root.add(btnRemove, 2, 1);

		GridPane.setHgrow(tfName, Priority.ALWAYS);
		GridPane.setVgrow(lvPersons, Priority.ALWAYS);

//		root.setGridLinesVisible(true);
//		stage.setResizable(false);
//		stage.setMinWidth(400);
//		stage.setMinHeight(150);

//		stage.setScene(new Scene(root, 450, 200));

		btnAdd.setOnAction(event -> {
			String s = tfName.getText();
			if (s.length() > 0  &&  !persons.contains(s))
				persons.add(s);
		});
		btnRemove.setOnAction(event ->
				persons.remove(lvPersons.getSelectionModel().getSelectedItem()));

		stage.setScene(new Scene(root));
		stage.setTitle("Anwesenheitskontrolle");
		stage.show();
	}

//	@Override
//	public void stop() {
//		var alert = new Alert(Alert.AlertType.INFORMATION,
//				"Vielen Dank für die Verwendung dieser Software!");
//		alert.setHeaderText("Bis bald!");
//		alert.showAndWait();
//	}

	public static void main(String[] args) {
		launch();
	}
}