interface WinterFace1 {
	void sagA();

	default void sagB() {
		sagA();
		IO.println("B");
	}

//	default String toString() {
//		// Verboten
//	}
}

interface WinterFace2 {
	void sagA();

	default void sagB() {
		sagA();
		IO.println("B");
	}
}

interface WinterFace3 extends WinterFace1, WinterFace2 {
	void sagA();

	void sagB();

	default void sagC() {
		IO.println("C");
	}
}


class Impl1 implements WinterFace1 {
	public void sagA() {
		IO.println("A");
	}
	
	void main() {
		var obj = new Impl1();
		obj.sagA();
	}
}


class Impl2 implements WinterFace1 {
	public void sagA() {
		IO.println("A");
	}

    void main() {
		var obj = new Impl2();
		obj.sagB();
	}
}


class Impl3 implements WinterFace1, WinterFace2 {
	public void sagA() {
		IO.println("A");
	}

	public void sagB() {
		IO.println("B");
	}

    void main() {
		Impl2 obj = new Impl2();
		obj.sagB();
	}
}
