void main() {
    var p = new Point(5, 10);
    RecordAnno da;

    IO.println("\nAnnotierte Record-Komponenten:");
    for (var rcomp : Point.class.getRecordComponents()) {
        da = rcomp.getAnnotation(RecordAnno.class);
        if (da != null)
            IO.println(" " + rcomp.getName());
    }

    IO.println("\nAnnotierte Methoden:");
    for (var meth : Point.class.getMethods()) {
        da = meth.getAnnotation(RecordAnno.class);
        if (da != null)
            IO.println(" " + meth.getName() + "()");
    }

    IO.println("\nAnnotierte Felder:");
    for (var field : Point.class.getDeclaredFields()) {
        da = field.getAnnotation(RecordAnno.class);
        if (da != null)
            IO.println(" " + field.getName());
    }

    IO.println("\nAnnotierte Konstruktorparameter:");
    for (var cpar : Point.class.getConstructors()[0].getParameters()) {
        da = cpar.getAnnotation(RecordAnno.class);
        if (da != null)
            IO.println(" " + cpar.getName());
    }
}
