package fimpack;

public class Kreis extends Figur {
	public int radius;

	public Kreis(String name_, int xpos_, int ypos_, int rad_) {
        radius = rad_;
		super(name_, xpos_, ypos_);
	}

	// Irrelevante Überladung, weil Kreis eine Implementation Comparable<Figur> erbt
    // und keine zusätzliche Implementation von Comparable<T> möglich ist.
	public int compareTo(Kreis kr) {
		if (xpos + radius < kr.xpos + kr.radius)
			return -1;
		else if (xpos + radius == kr.xpos + kr.radius)
			return 0;
		else
			return 1;
	}

	// Problematische Lösung, weil ein Array mit Figur- und Kreis-Objekten nicht konsistent sortiert wird.
//	@Override
//	public int compareTo(Figur fig) {
//		int pos = xpos;
//		int posPar = fig.xpos;
//		if (fig instanceof Kreis) {
//			pos = xpos + radius;
//			posPar = fig.xpos + ((Kreis) fig).radius;
//		}
//		if (pos < posPar)
//			return -1;
//		else if (pos == posPar)
//			return 0;
//		else
//			return 1;
//	}
}