import java.io.*;
import java.nio.charset.Charset;
import java.nio.file.*;

class OutputStreamWriterDemo {
	public static void main(String[] args) throws IOException {
		String[] encodings = {"US-ASCII", "ISO-8859-1", "UTF-8",
		                      "UTF-16BE", "UTF-16LE", "Windows-1252", "IBM850"};
		Files.deleteIfExists(Path.of("test.txt"));
		for (int i = 0; i < encodings.length; i++) {
			try (var osw = new OutputStreamWriter(
				     new FileOutputStream("test.txt", true), Charset.forName(encodings[i]))) {
				osw.write(encodings[i] + " ae = ä" + System.lineSeparator());
			}
		}
	}
}
