import java.io.*;
import java.nio.file.*;

class BufferedWriterDemo {
	static final int ANZAHL = 20_000_000;

	static void ohneBufferedWriter() throws IOException {
		for (int i = 0; i < 2; i++) {
			try (var fw = new FileWriter("test.txt")) {
				long time = System.currentTimeMillis();
				for (int j = 1; j <= ANZAHL; j++)
					fw.write("Zeile " + j + System.lineSeparator());
				fw.flush();
				if (i == 1)
					System.out.println("Benötigte Zeit ohne BufferedWriter:        "
						+ (System.currentTimeMillis() - time));
			}
			Files.delete(Path.of("test.txt"));
		}
	}

	static void mitBufferedWriter() throws IOException {
		for (int i = 0; i < 2; i++) {
			try (var bw = new BufferedWriter(new FileWriter("test.txt"))) {
				long time = System.currentTimeMillis();
				for (int j = 1; j <= ANZAHL; j++)
					bw.write("Zeile " + j + System.lineSeparator());
				bw.flush();
				if (i == 1)
					System.out.println("Benötigte Zeit mit BufferedWriter:         "
						+ (System.currentTimeMillis() - time));
			}
			Files.delete(Path.of("test.txt"));
		}
	}

	public static void main(String[] args) throws IOException {
		ohneBufferedWriter();
		mitBufferedWriter();
	}
}