import java.io.*;
import java.math.BigDecimal;

public class Kunde extends Person implements Serializable {
	private static final long serialVersionUID = 1L;
	private transient int stimmung;
	private int nkaeufe;
	private BigDecimal aussen;

	public Kunde(String vorname_, String name_, int stimmung_,
	             int nkaeufe_, BigDecimal aussen_) {
		vorname = vorname_;
		name = name_;
		stimmung = stimmung_;
		nkaeufe = nkaeufe_;
		aussen = aussen_;
	}

	private void writeObject(ObjectOutputStream oos) throws IOException {
		oos.defaultWriteObject();
		oos.writeObject(vorname);
		oos.writeObject(name);
	}

	private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
		ois.defaultReadObject();
		vorname = (String) ois.readObject();
		name = (String) ois.readObject();
	}

	public void prot() {
		System.out.println("Name: " + vorname + " " + name);
		System.out.println("Stimmung: " + stimmung);
		System.out.println("Anz. Einkäufe: " + nkaeufe +
		                   ", Außenstände: " + aussen+ "\n");
	}
}
