import java.io.IOException;
import java.nio.file.*;

class ProbeContentType {
	public static void main(String[] args) throws IOException {
		Path ordner = Path.of(System.getProperty("user.home"), "Documents","Java","Dateien");
		try (DirectoryStream<Path> stream = Files.newDirectoryStream(ordner)) {
			System.out.println("Inhaltstyp der Dateien im Verzeichnis " + ordner + ":\n");
		    for (Path path: stream)
		        System.out.printf("%-25s %s\n", path.getFileName(), Files.probeContentType(path));
		}
	}
}