import java.io.*;
import java.nio.file.*;

class DataOutputStreamDemo {
	public static void main(String[] args) throws IOException{
		Path file = Path.of("demo.dat");

		// int, double und String schreiben
		try (var dos = new DataOutputStream(Files.newOutputStream(file))) {
			dos.writeInt(4711);
			dos.writeDouble(Math.PI);
			dos.writeUTF("DataOutputStream-Demo");
		}
		
		// int, double und String lesen
		try (var dis = new DataInputStream(Files.newInputStream(file))) {
			System.out.println("readInt() - Ergebnis:    " + dis.readInt() +
							   "\nreadDouble() - Ergebnis: " + dis.readDouble() +
							   "\nreadUTF() - Ergebnis:    " + dis.readUTF());
		}
	}
}