import java.io.*;

class BufferedOutputStreamKonsole {
	public static void main(String[] egal) throws IOException {
		var fos = new FileOutputStream(FileDescriptor.out);
		var bos = new BufferedOutputStream(fos, 4);

		System.out.println("Pro Sekunde wird ein Byte in den Puffer geschrieben\n"+
		                   "Sind dort 4 bytes angesammelt, dann wandern sie zur Konsole.\n"+
		                   "Per Ton wird die Ankunft eines Bytes im Puffer gemeldet.\n");
		long time, start = System.currentTimeMillis();
		for (int i = 1; i <= 10; i++) {
			time = start + i*1000;
			while (System.currentTimeMillis() < time);
			bos.write(i + 47);
			System.out.print('\u0007');
		}

		System.out.println("\n\nRest aus dem Puffer:");
		bos.flush();
	}
}

