import java.io.*;
import java.nio.file.*;

class BufferedOutputStreamDatei {
	private final static int ANZAHL = 10_000;
	private final static Path AUSGABE = Path.of("Ausgabe.dat");

	public static void main(String[] args) throws IOException {
		long time;

		try (var fos = Files.newOutputStream(AUSGABE)) {
			time = System.currentTimeMillis();
			for (int i = 1; i <= ANZAHL; i++)
				fos.write(i);
			System.out.println("Zeit für die ungepufferte Ausgabe: " +
					(System.currentTimeMillis() - time));
		}

		try (var bos = new BufferedOutputStream(
				Files.newOutputStream(AUSGABE))) {
			time = System.currentTimeMillis();
			for (int i = 1; i <= ANZAHL; i++)
				bos.write(i);
			System.out.println("Zeit für die gepufferte Ausgabe:   " +
					(System.currentTimeMillis() - time));
			Files.delete(AUSGABE);
		}
	}
}
