package de.bebagoe.datareader;

import java.io.*;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.*;

public class Datenmatrix {
	private String[] names;
	private double[][] data;

	public boolean readData(String fileName) {
		try (var br = Files.newBufferedReader(Path.of(fileName))) {
			String line;
			if ((line = br.readLine()) == null) {
				System.out.println("Datei " + fileName + "ist leer");
				return false;
			}
			var stok = new StringTokenizer(line, " \t", false);
			int nvar = stok.countTokens(); 
			names = new String[nvar];
			for (int n = 0; n < nvar; n++)
				names[n] = stok.nextToken();

			List<double[]> tempData = new LinkedList<>();
			int ncas = 0;
			Scanner scanner;
			double[] da;
			while ((line = br.readLine()) != null) {
				ncas++;
				scanner = new Scanner(line);
				da = new double[nvar];
				for (int n = 0; n < nvar; n++)
					if (scanner.hasNextDouble()) 
						da[n] = scanner.nextDouble();
					else {
						System.out.println("Fehler beim Lesen von Fall " + ncas + ", Variable " + (n+1));
						System.out.println("Gelesen: |" + line + "|");
						return false;
					}
				tempData.add(da);
			}
			data = new double[ncas][nvar];
			Iterator<double[]> iterator = tempData.iterator();
			for (int m = 0; m < ncas; m++)
				data[m] = iterator.next();
			return true;
		} catch (IOException ioe) {
			System.out.println(ioe.getMessage());
			return false;
		}
	}

	public void printData() {
		if (data != null) {
			for (int n = 0; n < names.length; n++)
				System.out.printf("%10s", names[n]);
				System.out.println();
			for (int m = 0; m < data.length; m++) {
				for (int n = 0; n < names.length; n++)
					System.out.printf("%10.2f", data[m][n]);
				System.out.println();
			}
		}
	}
}
