public class Bruch {
	private int zaehler;    // wird automatisch mit 0 initialisiert
	private int nenner = 1;

	public void setzeZaehler(int z) {
		zaehler = z;
	}

	/*
	Ein Bruch-Objekt verhindert, dass sein Nenner auf 0
	gesetzt wird, und hat daher stets einen definierten Wert.
	*/
	public boolean setzeNenner(int n) {
		if (n != 0) {
			nenner = n;
			return true;
		} else
			return false;
	}

	public int gibZaehler() {
		return zaehler;
	}

	public int gibNenner() {
		return nenner;
	}

	public void kuerze() {
		// Größten gemeinsamen Teiler mit dem euklidischen Algorithmus bestimmen
		if (zaehler != 0) {
			int az = Math.abs(zaehler);
			int an = Math.abs(nenner);
			while (az != an)
				if (az > an)
					az = az - an;
				else
					an = an - az;
			zaehler = zaehler / az;
			nenner = nenner / az;
		} else
			nenner = 1;
	}

	public void addiere(Bruch b) {
		zaehler = zaehler * b.nenner + b.zaehler * nenner;
		nenner = nenner * b.nenner;
		kuerze();
	}

	public void frage() {
		int n;
		do {
			setzeZaehler(Simput.gint("Zähler: "));
		} while (Simput.checkError());
		do {
			// Bei irregulärer Eingabe liefert gint() eine 0 und setzt einen Fehlerindikator.
			n = Simput.gint("Nenner: ");
			if (n == 0 && !Simput.checkError())
				IO.println("Der Nenner darf nicht Null werden!\n");
		} while (n == 0);
		setzeNenner(n);
	}

	public void zeige() {
		System.out.printf("   %d\n -----\n   %d\n", zaehler, nenner);
	}
}

