package de.bebagoe.fakul;

class Fakul {
	/**
	 * Converts the input string into an int-Value.
	 *
	 * @throws IllegalArgumentException if parsing the argument fails
	 *         or the resulting value is not in [0 ... 170].
	 */
	static int convertInput(String instr)  throws IllegalArgumentException {
		try {
			int arg = Integer.parseInt(instr);
			if (arg < 0  || arg > 170)
				throw new IllegalArgumentException(
						"Unzulässiges Argument (erlaubt: 0 bis 170): " + arg);
			else
				return arg;
		} catch (NumberFormatException e) {
			throw new IllegalArgumentException("Fehler beim Konvertieren: " + instr, e);
		}
	}

    static void main(String args[]) {
        try {
            if (args.length == 0)
                throw new IllegalArgumentException("Kein Argument angegeben");
            int argument = convertInput(args[0]);
            double fakul = 1.0;
            for (int i = 1; i <= argument; i++)
                fakul = fakul * i;
            IO.println("Fakultät von " + argument + ": " + fakul);
        } catch (IllegalArgumentException iae) {
            IO.println(iae.getMessage());
            if (iae.getCause() != null)
                IO.println(" Ursache: " + iae.getCause().getMessage());
        }
    }
}
