import java.util.*;
import java.util.concurrent.locks.ReentrantLock;

class FinallyDemo implements Runnable {
	int konto;
	ReentrantLock lock = new ReentrantLock();
	Random ran = new Random();

	void abheben() {
		Scanner input = new Scanner(System.in);
		int amount;
		while (true) {
			try {
				try {
					Thread.sleep(3000);
				} catch (InterruptedException ignored) {
					// Die Ausnahme darf ignoriert werden, weil der Thread
					// keine Unterbrechungsaufforderung erhält.
				}
				lock.lock();
				IO.print("\nAbzuhebender Betrag (Beenden mit Betrag < 0): ");
				amount = Integer.parseInt(input.nextLine());
				if (amount < 0)
					System.exit(0);
				konto -= amount;
				IO.println("Neuer Kontostand:  " + konto);
			} catch(NumberFormatException e) {
				IO.println("Kein gültiger Betrag!");
			} finally {
				lock.unlock();
			}
		}
	}

	public void run() {
		while (true) {
			lock.lock();
			konto += ran.nextInt(30);
			System.out.print("\nKontostand erhöht auf: " + konto);
			lock.unlock();
			try {
				Thread.sleep(1000);
			} catch (InterruptedException ignored) {
				// Die Ausnahme darf ignoriert werden, weil der Thread
                // keine Unterbrechungsaufforderung erhält.
			}
		}
	}

	 static void main() {
		var fd = new FinallyDemo();
		(new Thread(fd)).start();
		fd.abheben();
	}
}
