// Aus Bloch (2018, S. 250)

static <E extends Comparable<E>> Optional<E> max(Collection<E> c) {
    if (c == null || c.isEmpty())
        return Optional.empty();
    E result = null;
    for (E e : c)
        if (e != null)
            if (result == null)
                result = e;
            else if (e.compareTo(result) > 0)
                result = e;
    return Optional.ofNullable(result);
}

void main() {
    List<String> los = List.of("b", "d", "c", "a"); IO.println(max(los));
    List<String> elos = List.of(); IO.println(max(elos));
    List<String> lon = Arrays.asList(null, "a", null); IO.println(max(lon));
}

