final static double LOG2 = Math.log(2);

/**
 * Computes Log Base 2
 *
 * @throws IllegalArgumentException if argument is <= 0
 */
static double duaLog(double arg) {
    if (arg > 0)
        return Math.log(arg) / LOG2;
    else
        throw new IllegalArgumentException("Argument <= 0: " + arg);
}

void main() {
    double a = duaLog(8);
    double b = duaLog(-1);
    IO.println(a * b);
}