package de.bebagoe.fakul;

class Fakul {
	/**
	 * Converts the input string into an int-Value.
	 *
	 * @throws BadFactorialArgException if the argument is missing, parsing fails
	 *         or the value is not in [0 ... 170].
	 */
	static int convertInput(String instr) {
        int arg;
		try {
			if (instr == null)
				throw new BadFactorialArgException("String-Parameter ist null.", "", 1, -1);
			arg = Integer.parseInt(instr);
			if (arg < 0  || arg > 170)
				throw new BadFactorialArgException(
					"Unzulässiger Wert (erlaubt: 0 bis 170)", instr, 3, arg);
			else
				return arg;
		} catch (NumberFormatException e) {
			throw new BadFactorialArgException("Fehler beim Konvertieren", instr, 2, -1);
		}
	}

    static void main(String[] args) {
        if (args.length == 0) {
            IO.println("Kein Argument angegeben");
            System.exit(1);
        }
        try {
            int argument = convertInput(args[0]);
            double fakul = 1.0;
            for (int i = 1; i <= argument; i++)
                fakul = fakul * i;
            IO.println("Fakultät von " + argument + ": " + fakul);
        } catch (BadFactorialArgException e) {
            int error = e.getError();
            if (error == 2 || error == 3) {
                IO.println("Fehlerhaftes Argument: " + e.getMessage());
                switch (error) {
                    case 2 -> IO.println(" Zeichenfolge: \"" + e.getInstr() + "\"");
                    case 3 -> IO.println(" Wert: " + e.getValue());
                }
            } else
                IO.println("Unbekannter Fehler");
        }
    }
}
